local Time = Game.Time
local Delay1 = 10
local Delay2 = 1
local ReadyTime1 = Time()
local ReadyTime2 = Time()

local origX = nil
local origY = nil
local origPosSet = false

local interfaceInitialized = false
local selectionPercent = 50
local gasNozzles = {}

function Create()
end

function Update(timePassed)
	if Time() > ReadyTime1 then
		if origPosSet == false then
			origX = this.Pos.x
			origY = this.Pos.y
			origPosSet = true
		end
		if interfaceInitialized == false then
			Interface.AddComponent(this, "changeSelectionPercent", "Button", "Selection: "..selectionPercent.."%")
			interfaceInitialized = true
		end
		PerformUpdate1()
		ReadyTime1 = ReadyTime1 + Delay1
	end
	if Time() > ReadyTime2 then
		PerformUpdate2()
		ReadyTime2 = ReadyTime2 + Delay2
	end
end

function PerformUpdate1()
	gasNozzles = {}
	local gns = this.GetNearbyObjects("GasNozzle", 1000)
	for gn, range in pairs(gns) do
		table.insert(gasNozzles, {x=gn.Pos.x, y=gn.Pos.y})
		-- Game.DebugOut("Found GasNozzle at"..gn.Pos.x..", "..gn.Pos.y)
	end
end

function PerformUpdate2()
	this.NavigateTo(origX, origY)
	local prisoners = this.GetNearbyObjects("Prisoner", 10)
	for pr, range in pairs(prisoners) do
		if pr.IsNewIntake and Object.GetProperty(pr, "SelectedForGasChamber") == nil then
			if math.random(0, 100) <= selectionPercent then
				if #gasNozzles > 0 then
					Object.SetProperty(pr, "SelectedForGasChamber", true)
					SendPrisonerToGasChamber(pr)
				end
			else
				Object.SetProperty(pr, "SelectedForGasChamber", false)
			end
		end
	end
end

function SendPrisonerToGasChamber(pr)
	local gnPos = gasNozzles[math.random(#gasNozzles)]
	Object.SetProperty(pr, "GasNozzlePosX", gnPos.x)
	Object.SetProperty(pr, "GasNozzlePosY", gnPos.y)
	Game.DebugOut("Sending prisoner to GasNozzle @ "..gnPos.x..", "..gnPos.y)
	pr.NavigateTo(gnPos.x, gnPos.y)
end

function changeSelectionPercentClicked()
	selectionPercent = selectionPercent + 5
	if selectionPercent > 100 then
		selectionPercent = 0
	end
	this.SetInterfaceCaption("changeSelectionPercent", "Selection: "..selectionPercent.."%")
end